<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// BEGIN ENQUEUE PARENT ACTION
// AUTO GENERATED - Do not modify or remove comment markers above or below:

if ( !function_exists( 'chld_thm_cfg_locale_css' ) ):
    function chld_thm_cfg_locale_css( $uri ){
        if ( empty( $uri ) && is_rtl() && file_exists( get_template_directory() . '/rtl.css' ) )
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;
add_filter( 'locale_stylesheet_uri', 'chld_thm_cfg_locale_css' );

if ( !function_exists( 'chld_thm_cfg_parent_css' ) ):
    function chld_thm_cfg_parent_css() {
        wp_enqueue_style( 'chld_thm_cfg_parent', trailingslashit( get_template_directory_uri() ) . 'style.css', array(  ) );
    }
endif;
add_action( 'wp_enqueue_scripts', 'chld_thm_cfg_parent_css', 10 );

// END ENQUEUE PARENT ACTION

function my_theme_enqueue_styles() {    
    //wp_enqueue_style( 'my-custom-font', get_stylesheet_directory_uri() . '/assets/fonts/stylesheet.css' );
    wp_enqueue_style( 'my-font-awesome', get_stylesheet_directory_uri() . '/assets/font-awesome/css/font-awesome.css' );   }
add_action( 'wp_enqueue_scripts', 'my_theme_enqueue_styles' );

/**=============================================
 * create new column in et_pb_layout screen
 *==============================================*/ 

add_filter( 'manage_et_pb_layout_posts_columns', 'ds_create_shortcode_column', 5 );
add_action( 'manage_et_pb_layout_posts_custom_column', 'ds_shortcode_content', 5, 2 );
// register new shortcode
add_shortcode('ds_layout_sc', 'ds_shortcode_mod');

/**=============================================
 * // New Admin Column
 *==============================================*/ 

function ds_create_shortcode_column( $columns ) {
$columns['ds_shortcode_id'] = 'Module Shortcode';
return $columns;
}

//Display Shortcode
function ds_shortcode_content( $column, $id ) {
if( 'ds_shortcode_id' == $column ) {
?>
<p>[ds_layout_sc id="<?php echo $id ?>"]</p>
<?php
}
}

/**=============================================
 * // Create New Shortcode
 *==============================================*/ 

function ds_shortcode_mod($ds_mod_id) {
extract(shortcode_atts(array('id' =>'*'),$ds_mod_id));
return do_shortcode('[et_pb_section global_module="'.$id.'"][/et_pb_section]');
}

/*===================================================
           All Update Disable
=====================================================*/

function remove_core_updates(){
global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);
}
// add_filter('pre_site_transient_update_core','remove_core_updates');
// add_filter('pre_site_transient_update_plugins','remove_core_updates');
// add_filter('pre_site_transient_update_themes','remove_core_updates');

/*====================================================================
 * Start Google Tag Manager Code
 * ===================================================================*/

//add_action( 'Google_Tag_Manager_Head', 'Google_tag_manager_head' );
if ( !function_exists( 'Google_tag_manager_head' ) ) :
	function Google_tag_manager_head() { ?>
			<!-- Google Tag Manager Head-->
			<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
			new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
			j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
			'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
			})(window,document,'script','dataLayer','GTM-K947ZVD');</script>
			<!-- End Google Tag Manager Head -->
	<?php }
endif;

//add_action( 'wp_body_open', 'Google_tag_manager_body' );
if(!function_exists('Google_tag_manager_body')):
	function Google_tag_manager_body(){ 
		echo '<!-- Google Tag Manager (noscript) --><noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-K947ZVD"
		height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript><!-- End Google Tag Manager (noscript) -->';
	}
endif;

/*====================================================================
 * End Google Tag Manager Code
 * ===================================================================*/

/*====================================================================
 * Whatsapp Icon For every pages
 * ===================================================================*/

add_action('wp_footer', 'Whatsapp_Icon_Code');
if(!function_exists('Whatsapp_Icon_Code')):
	function Whatsapp_Icon_Code(){ ?>
		<!-- GetButton.io widget -->
		<script type="text/javascript">
			(function () {
				var options = {
					whatsapp: "+91 90081 63304", // WhatsApp number
					call_to_action: "Message us", // Call to action
					position: "left", // Position may be 'right' or 'left'
				};
				var proto = document.location.protocol, host = "getbutton.io", url = proto + "//static." + host;
				var s = document.createElement('script'); s.type = 'text/javascript'; s.async = true; s.src = url + '/widget-send-button/js/init.js';
				s.onload = function () { WhWidgetSendButton.init(host, proto, options); };
				var x = document.getElementsByTagName('script')[0]; x.parentNode.insertBefore(s, x);
			})();
		</script>
		<!-- /GetButton.io widget -->
	<?php }
endif;
